#pragma once
#ifndef __GPIO_H__
#define __GPIO_H__

#include "project.h"
//-----------------------------------------------------------------------------------
#define inTLplus		(PA->IDR  &  GPIO1)
#define inTLminus		(PA->IDR  &  GPIO2)
// Led break
#define ledBRKpin		(4)
#define ledBRKport		(PD)
#define inBRKled		(ledBRKport->IDR  &  (1 << ledBRKpin))
#define ledBRKinit		(ledBRKport->DDR |=  (1 << ledBRKpin))
#define ledBRKpool		(ledBRKport->CR1 |=  (1 << ledBRKpin))
#define ledBRKon		(ledBRKport->ODR &= ~(1 << ledBRKpin))
#define ledBRKoff		(ledBRKport->ODR |=  (1 << ledBRKpin))
#define ledBRKinverse	(ledBRKport->ODR ^=  (1 << ledBRKpin))
// RELE output
#define outRELEpin		(4)
#define outRELEport		(PB)
#define inRELE			(~(outRELEport->IDR >> outRELEpin) & 1)
#define outRELEinit		(outRELEport->DDR |=  (1 << outRELEpin))
#define outRELEpoolON	(outRELEport->CR1 |=  (1 << outRELEpin))
#define outRELEpoolOFF	(outRELEport->CR1 &= ~(1 << outRELEpin))
#define outRELEoff		(outRELEport->ODR &= ~(1 << outRELEpin))
#define outRELEon		(outRELEport->ODR |=  (1 << outRELEpin))
#define outRELEinverse	(outRELEport->ODR ^=  (1 << outRELEpin))
// FAN output
#define outFANpin		(3)
#define outFANport		(PA)
#define inFAN			((outFANport->IDR >> outFANpin) & 1)
#define outFANinit		(outFANport->DDR |=  (1 << outFANpin))
#define outFANpoolON	(outFANport->CR1 |=  (1 << outFANpin))
#define outFANpoolOFF	(outFANport->CR1 &= ~(1 << outFANpin))
#define outFANoff		(outFANport->ODR &= ~(1 << outFANpin))
#define outFANon		(outFANport->ODR |=  (1 << outFANpin))
#define outFANinverse	(outFANport->ODR ^=  (1 << outFANpin))
// Led werning
//#ifdef lightverze
#define inWARled		(PD->IDR  &  GPIO1)
#define ledWARinit		(PD->DDR |=  GPIO1)
#define ledWARpool		(PD->CR1 |=  GPIO1)
#define ledWARon		(PD->ODR &= ~GPIO1)
#define ledWARoff		(PD->ODR |=  GPIO1)
#define ledWARinverse	(PD->ODR ^=  GPIO1)
//#endif
// Led PWM
#define inPWMled		(PC->IDR  &  GPIO5)         // nefunguje bez pull-up
#define ledPWMinit		(PC->DDR |=  GPIO5)
#define ledPWMpool		(PC->CR1 |=  GPIO5)
#define ledPWMon		(PC->ODR &= ~GPIO5)
#define ledPWMoff		(PC->ODR |=  GPIO5)
#define ledPWMinverse	(PC->ODR ^=  GPIO5)
// Most
#define inH1    		(PC->IDR  &  GPIO6)
#define inL1    		(PC->IDR  &  GPIO3)
#define inH2    		(PC->IDR  &  GPIO7)
#define inL2    		(PC->IDR  &  GPIO4)

#define NTCpullup	//	for pull-up configuration
//-----------------------------------------------------------------------------------
#define ledPWMconOFF     ledPWMconMAX + 1
#define ledPWMconON      0
#define ledPWMconMAX   125
#define ledPWMconTICK    8
#define ledBRKconOFF     0
#define ledBRKconON      ledBRKconMAX + 10
#define ledBRKconMAX    10
#define ledBRKconTICK  100
#define ledWARconOFF     0
#define ledWARconON      ledWARconMAX + 10
#define ledWARconMAX     8
#define ledWARconTICK  100
//-----------------------------------------------------------------------------------
extern uint8_t ledWARflag;
extern uint8_t ledBRKflag;
extern uint8_t ledPWMflag;
//-----------------------------------------------------------------------------------
void GPIOconfig(void);
//void ledWarning(void);
//void fanWarning(void);
void brk(uint8_t type);
float Thermister(int rawADC);
void LSIconfig(void);
void HSIconfig(void);
void AWUconfig(void);
void ledPWMinterrupt(void);
void ledWARinterrupt(void);
void ledBRKinterrupt(void);
void ledPWMset(void);
void ledBRKset(void);
void releSET(void);
void fanSET(void);

#endif // __GPIO_H__

