#include "main.h"
#include "model.c"
#include "interupt.c"
//-----------------------------------------------------------------------------------
uint8_t rezim;
uint8_t state_print;
uint8_t buttonSTART = 0;
//-----------------------------------------------------------------------------------
void main(void)
{
    uint8_t  flgMPPTfirst = 0;
    uint8_t  flgSTOP = 0;
    
	PA->CR1 = 0b00000110; // Tl pull-up
	HSIconfig();
	AWUconfig();
	ADCconfig();
    TIMER4config();
    enableInterrupts();
	CONFread();
    CONFregul();
    delay(200);
    buttonSTART = 1;
    delay(60);
	while(rezim >= 2)
	{
		if(flgTLplus || flgTLminus) break;
        system8.ADCdivU = 0;
        ADCstart();
        ADCinterupt();
        ADCvalue();
        ADCstop();
        if(state_Uk > system16.Uzap) break;
		halt();
	}
	GPIOconfig();
	UARTconfig();

  	state_print = 1;
    UARTprintF((uint16_t *)0x4826);
    UARTnumber(RST->SR);
    UARTprintF((uint16_t *)textWatchdog);

	if (flgTLplus && !flgTLminus) CONFload();
	if (!flgTLplus && flgTLminus) CONFmode();

    #ifdef IWDGstart
	IWDGinit(0x06); // Time out 1,02s
    #endif

	CONFread();
    CONFregul();
	CONFprint();
	TIMER1config();
	TIMER2config();
    ADCstart();
	ADCfirst();
	ADCvalue();
    
	while(1)
	{
    labelSTART:
       #ifdef LIGHT
        if(milliscnt > 300000) state_print = 0;                 // vypne uart za 300 s - 5 min.
       #endif

        setMAX();       // zapsaní nových dosažených maxim
        PWMfout();      // změna frekvence podle Ik
        PWMlimit();	    // omezení podle teploty/eeprom
		PWMmeze();      // ošetření mezí
        if(state_PWMkm1 == 0 && state_PWM  > 0) PWMstart(); else
        if(state_PWMkm1  > 0 && state_PWM == 0) PWMstop();  else
        if(state_PWMkm1 != state_PWM || state_Fk != state_Fkm1) PWMset();
		if(delayUART == 0 || system8.jet == 1 || (rezim <= 1 && state_PWMkm1 != state_PWM)) UARTregul();
        state_PWMkm1 = state_PWM;
        state_Fkm1   = state_Fk;

       #ifndef TEST
        if(state_Uk > conUmax)                  brk(4);         // vypnutí regulace Uk > 400V
        if(state_rawTk > 99)                    brk(3);         // vadný NTC
       #endif
        if(state_Tk > system16.Tvyp)            brk(2);         // přehřádý regulátor
        if(flgUset != 0) {setUnap(); goto labelSTART;}          // zkrácení smyčky při zjišťování Unap

        ledBRKset();    // nastavení ledBRK podle omezování PWM
		ledPWMset();    // nastavení výkonové led
		fanSET();       // ovládání fan
		TLregul();      // vyhodnocení tlačítek

    	if(rezim == 0 && state_Uk > system16.Uzap) rezim = 3;   // přepne test pro vysoké napětí
    	if(rezim <= 1) goto labelSTART;                         // test a ruční režim
		releSET();      // ovládání relátka zátěže místo fan

        if(rezim == 2 && state_Uk > 290) // ochrana motoru při Uk > 290V
        {
            delayOFFpwm  = system16.OFFms >> 1;
            if(delayPause) goto labelSTART;
            state_PWM = 0;
        } else
		if(flgSTOP == 0 && state_Uk < system16.Uvyp) // zastavení regulátoru Uk < Uvyp
		{
            PWMstop();
            EEPROMsave();
            flgSTOP = 1;
		} else
        if(state_Uk < system16.Uzap) // vypnutí regulace Uk < Uzap
        {
            if(rezim == 2) {
                delayOFFpwm  = system16.OFFms >> 1;
                if(delayPause) goto labelSTART;
            }
            rezim = system8.mode;
            state_PWM = 0;
        } else
       #ifndef TEST
        if(state_rawTk < 5) {state_PWM = 0; goto labelSTART;} else  // vypnutí měniče
       #endif
		if(delayOFFpwm) goto labelSTART;
		else // zapnutí regulace Uk > Uzap
		{
			if(system16.OFFpwm !=0 && state_PWM > system16.OFFpwm && state_rawIk < 5)
			{
                delayOFFpwm  = system16.OFFms >> 1; 
                state_PWM = 0;
                rezim = 8;
			}
			else
			{
                flgSTOP = 0;
                if(state_Pk > conPmax)                        {rezim = 7;} else
                if(state_Ik > conImax)                        {rezim = 6;}
                if(rezim >= 6 && ((state_Pk < (conPmax - 100) && state_Ik < (conImax - 500)) || state_Uk < state_Ulow - 10))
                                                              {rezim = system8.mode; flgMPPTfirst = 0;}
    			if(rezim == 4 && state_Ik > system16.mppIzap) {rezim = 5;}
    			if(rezim == 5 && state_Ik < system16.mppIvyp) {rezim = 4; flgMPPTfirst = 0;}
				if(rezim == 5 && delayMPPT == 0) // mppt
				{
                    if(flgMPPTfirst != 0) mpptINCCOND();
                    flgMPPTfirst = 1;
                    delayMPPT = system16.mppTIME >> 1;
				    setLASTvalue(); // vyčlenit last pro MPPT, aby se last mohlo využít pro vzorkování
				}
    			runPIreg();
			}
		}
	}
}
//-----------------------------------------------------------------------------------

