/*
 ********************* Timer2 ********************
 * prescaler: TIM2_PSCR f = f_{in}/2^{TIM2_PSCR}
 * other registers:
 * TIM2_CR1 (page 223): | ARPE | reserved[2:0] | OPM | URS | UDIS | CEN |
 *              ARPE - Auto-reload preload enable (for TIM2_ARR)
 *              OPM: One-pulse mode (not implemented!)
 *              URS: Update request source (When enabled by the UDIS bit, 1 - interrupt only on counter overflow/underflow)
 *              UDIS: Update disable (1 - disable update int)
 *              CEN: Counter enable (1 - enable)
 * TIM2_IER (page 226): | x | TIE | x | x | CC3IE | CC2IE | CC1IE | UIE |
 *              T - trigger; CC - comp/capt; U - update <--
 * TIM2_SR1 (page 227): | x | TIF | x | x | CC3IF | CC2IF | CC1IF | UIF |
 *              T - trigger; CC - comp/capt; U - update <--
 * TIM2_SR2 (page 228): overcapture flags
 * TIM2_EGR (page 229): event generation  | x | TG | x | CC3G | CC2G | CC1G | UG |
 * TIM2_CCMR1 (page 230):
 * OUTPUT:  | res | OC1M[2:0] | OC1PE | res | CC1S[1:0] |
 * INPUT:   | IC1F[3:0] | IC1PSC[1:0] | CC1S[1:0] |
 *              OC1M: compare mode !!! writeable only when channel is off (CC1E=0) !!!
 *               000: no
 *               001: set channel 1 to active level on match
 *               010: set chan1 to inactive ...
 *               011: toggle
 *               100: force 0
 *               101: force 1
 *               110: PWM mode 1 (1->0)
 *               111: PWM mode 2 (0->1)
 *              OC1PE: output compare 1 preload enable (0 - loads immediately)
 *              CC1S: comp/capt selection
 *               00: CC1 is out
 *               01: CC1 is in (TI1FP1)
 *               10: TI2FP1
 *               11: (only for TIM5)
 *              IC1F: input capture filter  (0 - no filter)
 *              IC1PSC: capture prescaler (0 - no, xx - 2^{xx} events)
 * TIM2_CCMRx - the same for channels 2 & 3
 * TIM2_CCERx - CC polarity/enable (lowest 2 bytes in each 4): P=1:active high/capture on rising edge;
 * TIM2_CNTRH, TIM2_CNTRL - counter value (automatical)
 * TIM2_PSCR - prescaler value, lower 4 bits
 * TIM1_ARRH, TIM1_ARRL   - auto-reload value (while zero, timer is stopped) (page 206)
 * TIM2_CCRxL/H - compare/capture registers
 */
#include "timer2.h"

uint16_t tim2ARR;
uint16_t tim2ARR_const;
//
void TIMER2config(void)
{
    TIM2->PSCR  = 0x03;         //  0,5us/20kHz při 16Mhz; 2^PSCR/16; PSCR = 3
	TIM2->ARRH  = 0;
	TIM2->ARRL  = 100;
    TIM2->CCR3H = 0;            // nejprve zapsat H a potom L
    TIM2->CCR3L = 70;           // po zapnutí vynuluje čítač

//	TIM2->CCMR1 = 0b00000000;	//	x		OC1M	OC1M	OC1M	OC1PE	x		CC1S	CC1S
//	TIM2->CCMR1 = 0b00000000;	// | IC1F[3:0] | IC1PSC[1:0] | CC1S[1:0] |

//	TIM2->CCMR2 = 0b01101000;	//	x		OC2M	OC2M	OC2M	OC2PE	x		CC2S	CC2S

	TIM2->CCMR3 = 0b01111000;	//	x		OC3M	OC3M	OC3M	OC3PE	x		CC3S	CC3S

//	TIM2->CCER1 = 0b00000000;	//	x		x		CC2P	CC2E	x		x		CC1P	CC1E

//	TIM2->CCER2 = 0b00000011;	//	x		x		x		x		x		x		CC3P	CC3E

    TIM2->EGR   = 0b00000001;   // | x | TG | x | x | CC3G | CC2G | CC1G | UG |
//  TIM2->IER   = 0b00001001;   // | x | TIE | x | x | CC3IE | CC2IE | CC1IE | UIE |
//  TIM2->SR1   = 0b00000001;   // | x | TIF | x | x | CC3IF | CC2IF | CC1IF | UIF |
    TIM2->CR1   = 0b10000101;	//	ARPE	x		x		x		OPM		URS		UDIS	CEN
}

