var bodyHeight = $('body').height();    
var footerHeight = $('footer.footer.footer-bottom').height();
var headerHeight = $('header').height();
var windowWidth = $(window).width(); //retrieve current window width
var windowHeight = $(window).height(); //retrieve current window height
var scrollTop  = $(document).scrollTop();

$(document).ready(function(){

    $(window).resize(function(){
        /* resize */
        pageDimensions();
    });

    $('body').removeClass('header-hidden');
    $(window).scroll(function(){
      scrollTop  = $(document).scrollTop();
      if (scrollTop>100){
        $('body').addClass('header-hidden');
      }else{
        $('body').removeClass('header-hidden');
      }
      $('.debug').html(scrollTop);
    });


    /* scroll */
    $('.nav.nav-main a').click(function(e){
      var thisTarget = $(this).attr('href');
      $('.nav.nav-main li').removeClass('current-menu-item');
      $(this).closest('li').addClass('current-menu-item');
      var pos = $(thisTarget).position();
      $('body').scrollTo(pos.top - 75,500);
      e.preventDefault();
    });
    $('.logo').click(function(e){
      $('body').scrollTo(0,500);
      e.preventDefault();
    });


    /* menu toggle */
    $('.menu-toggle').click(function(e){
        $('body').toggleClass('menu-active')
        e.preventDefault();
    }); 



});


$(window).on("load", function (e) {
  pageDimensions();


});


/* CORE FUNCTIONS */
function pageDimensions(){
    bodyHeight = $('body').height();    
    footerHeight = $('footer.footer.footer-bottom').height();
    headerHeight = $('header').height();
    windowWidth = $(window).width();
    windowHeight = $(window).height();
    pageMeasurement = windowWidth/windowHeight;
    scrollTop  = $(document).scrollTop();

}
function UtilityHasTouch() {    

    var agent   = navigator.userAgent;

    if ( agent.match(/(iPhone|iPod|iPad|Blackberry|Android)/) ) {
        return true;
    }

    try {
        document.createEvent("TouchEvent");
        return true;
    } catch (e) {
        return false;
    }
}
function getUrlVars() {
    var vars = {};
    var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m,key,value) {
        vars[key] = value;
    });
    return vars;
}
function numberWithCommas(x) {
    var parts = x.toString().split(".");
    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, " ");
    return parts.join(".");
}
function mapInit(lat,lng,id){
    var place = new google.maps.LatLng(lat,lng);
    var mapOptions = {
      center: new google.maps.LatLng(lat,lng),
      zoom: 17,
      controls: true,
        scrollwheel: false,
        navigationControl: true,
        mapTypeControl: true,
        scaleControl: true,
        streetViewControl: false,
        
        navigationControl: true,
        mapTypeControl: true,
        scaleControl: true,
        draggable: true
        
    };
    var map = new google.maps.Map(document.getElementById(id),
        mapOptions);

    var marker, i;
    if (id=='map-canvas2'){
        var locations = [
          ['', 50.2419174,12.8415519, 2]
        ];
        var image = 'img/marker.png';
    }else{
        var image = 'img/marker.png';
    }

    for (i = 0; i < locations.length; i++) {  
      marker = new google.maps.Marker({
        position: new google.maps.LatLng(locations[i][1], locations[i][2]),
        icon: image,
        map: map
      });

      /*google.maps.event.addListener(marker, 'click', (function(marker, i) {
        return function() {
          infowindow.setContent(locations[i][0]);
          infowindow.open(map, marker);
        }
      })(marker, i));*/
    }

    /*var marker = new google.maps.Marker({
        position: place,
        map: map
    });
    google.maps.event.addListener(marker, 'click', function() {
        
    });*/
}